from __future__ import absolute_import
import logging
import re
from utils import (
    bytes_to_int,
    int_to_bytes,
    hex_string_to_int,
    extract_bits_from_byte,
)

logger = logging.getLogger(__name__)

def extract_bits(data, bits):
    r = re.compile(r'\d{1,}:\d{1,}')
    if not bool(r.match(bits)):
        start = bits
        end = int(start) + 1
    else:
        end, start = bits.split(':')
    return extract_bits_from_byte(data, int(start), int(end))


def set_item_data(data, data_desc):
    """[summary]

    Arguments:
        data {bytes} -- data as bytes
        data_desc {dict} -- dict that describes the data

    Returns:
        [tuple] -- offset, size and bytes
    """
    int_offset = hex_string_to_int(data_desc.get('offset', '0x0'))
    if isinstance(data_desc.get('size', '0x0'), dict):
        from cse_image_items.DataItem import DataItem
        int_size = DataItem(data[int_offset:], **data_desc['size']).int_value()
    else:
        int_size = hex_string_to_int(data_desc.get('size', '0x0'))
    item_data = data[int_offset:int_offset + int_size]
    if data_desc.get('bits'):
        item_data = extract_bits(item_data, data_desc['bits'])
    if data_desc.get('bitwiseOperation'):
        temp = eval(
            ('%s %s' % (bytes_to_int(item_data), data_desc['bitwiseOperation'])))
        item_data = int_to_bytes(temp)
    return int_offset, int_size, item_data
